	function bin = dectobin(dec, width, signed)
	%bin = dectobin(dec, width, signed)
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	if size(dec, 2) > 1
		error "dectobin : column vector required"
	end
	
	N = length(dec);
	bin = zeros(N, width);
	
	if signed == 0
		if any(dec < 0) | any(dec >= 2^width)
			disp(sprintf('Warning: dectobin: argument overflow'));
		end
	
		for n = width-1:-1:0
			v = dec >= 2^n;
			bin(:, width-n) = v;
			dec = dec - 2^n*v;
		end
	elseif signed == 1
		if any(dec < -2^(width-1)) | any(dec >= 2^(width-1))
			disp(sprintf('Warning: dectobin: argument overflow'));
		end
	
		v = dec < 0;
		dec = dec + 2^width*v;
	
		for n = width-1:-1:0
			v = dec >= 2^n;
			bin(:, width-n) = v;
			dec = dec - 2^n*v;
		end
	else
		error "dectobin : signed argument invalid"
	end
	
